/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class CompactingHelper {
    private static final InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static final InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static final InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private final class_1937 world;

    public CompactingHelper(class_1937 world) {
        this.world = world;
    }

    @NotNull
    public Result findHigherTier(@NotNull class_1799 stack) {
        class_1799 modMatch;
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get();
        if (!this.world.field_9236 && debugTrace) {
            ModServices.log.info("Finding ascending candidates for " + stack.toString());
        }
        if ((record = CompTierRegistry.INSTANCE.findHigherTier(stack)) != null) {
            if (!this.world.field_9236 && debugTrace) {
                ModServices.log.info("Found " + record.upper.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.upper, record.convRate);
        }
        ArrayList<class_1799> candidates = new ArrayList<class_1799>();
        int lookupSize = this.setupLookup(lookup3, stack);
        List<class_1799> fwdCandidates = this.findAllMatchingRecipes((class_8566)lookup3);
        if (fwdCandidates.size() == 0) {
            lookupSize = this.setupLookup(lookup2, stack);
            fwdCandidates = this.findAllMatchingRecipes((class_8566)lookup2);
        }
        if (fwdCandidates.size() > 0) {
            block0: for (class_1799 match : fwdCandidates) {
                this.setupLookup(lookup1, match);
                List<class_1799> backCandidates = this.findAllMatchingRecipes((class_8566)lookup1);
                for (class_1799 comp : backCandidates) {
                    if (comp.method_7947() != lookupSize || !ItemStackMatcher.areItemsEqual(comp, stack)) continue;
                    candidates.add(match);
                    if (this.world.field_9236 || !debugTrace) continue block0;
                    ModServices.log.info("Found ascending candidate for " + stack.toString() + ": " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
                    continue block0;
                }
            }
        }
        if (!(modMatch = this.findMatchingModCandidate(stack, candidates)).method_7960()) {
            return new Result(modMatch, lookupSize);
        }
        if (candidates.size() > 0) {
            return new Result((class_1799)candidates.get(0), lookupSize);
        }
        if (!this.world.field_9236 && debugTrace) {
            ModServices.log.info("No candidates found");
        }
        return new Result(class_1799.field_8037, 0);
    }

    @NotNull
    public Result findLowerTier(@NotNull class_1799 stack) {
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get();
        if (!this.world.field_9236 && debugTrace) {
            ModServices.log.info("Finding descending candidates for " + stack.toString());
        }
        if ((record = CompTierRegistry.INSTANCE.findLowerTier(stack)) != null) {
            if (!this.world.field_9236 && debugTrace) {
                ModServices.log.info("Found " + record.lower.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.lower, record.convRate);
        }
        ArrayList<class_1799> candidates = new ArrayList<class_1799>();
        HashMap<class_1799, Integer> candidatesRate = new HashMap<class_1799, Integer>();
        for (class_1860 recipe : this.world.method_8433().method_30027(class_3956.field_17545)) {
            class_1799 match;
            class_1799 output = recipe.method_8110(this.world.method_30349());
            if (!ItemStackMatcher.areItemsEqual(stack, output) || (match = this.tryMatch(stack, (class_2371<class_1856>)recipe.method_8117())).method_7960()) continue;
            int lookupSize = this.setupLookup(lookup1, output);
            List<class_1799> compMatches = this.findAllMatchingRecipes((class_8566)lookup1);
            for (class_1799 comp : compMatches) {
                int recipeSize = recipe.method_8117().size();
                if (ItemStackMatcher.areItemsEqual(match, comp) && comp.method_7947() == recipeSize) {
                    candidates.add(match);
                    candidatesRate.put(match, recipeSize);
                    if (this.world.field_9236 || !debugTrace) continue;
                    ModServices.log.info("Found descending candidate for " + stack.toString() + ": " + match.toString() + " size=" + recipeSize + ", inverse=" + comp.toString());
                    continue;
                }
                if (this.world.field_9236 || !debugTrace) continue;
                ModServices.log.info("Back-check failed for " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
            }
        }
        class_1799 modMatch = this.findMatchingModCandidate(stack, candidates);
        if (!modMatch.method_7960()) {
            return new Result(modMatch, (Integer)candidatesRate.get(modMatch));
        }
        if (candidates.size() > 0) {
            class_1799 match = (class_1799)candidates.get(0);
            return new Result(match, (Integer)candidatesRate.get(match));
        }
        if (!this.world.field_9236 && debugTrace) {
            ModServices.log.info("No candidates found");
        }
        return new Result(class_1799.field_8037, 0);
    }

    private List<class_1799> findAllMatchingRecipes(class_8566 crafting) {
        ArrayList<class_1799> candidates = new ArrayList<class_1799>();
        for (class_3955 recipe : this.world.method_8433().method_17877(class_3956.field_17545, (class_1263)crafting, this.world)) {
            class_1799 result;
            if (!recipe.method_8115((class_1263)crafting, this.world) || (result = recipe.method_8116((class_1263)crafting, this.world.method_30349())).method_7960()) continue;
            candidates.add(result);
        }
        return candidates;
    }

    @NotNull
    private class_1799 findMatchingModCandidate(@NotNull class_1799 reference, List<class_1799> candidates) {
        class_2960 referenceName = class_7923.field_41178.method_10221((Object)reference.method_7909());
        if (referenceName != null) {
            for (class_1799 candidate : candidates) {
                class_2960 matchName = class_7923.field_41178.method_10221((Object)candidate.method_7909());
                if (matchName == null || !referenceName.method_12836().equals(matchName.method_12832())) continue;
                return candidate;
            }
        }
        return class_1799.field_8037;
    }

    @NotNull
    private class_1799 tryMatch(@NotNull class_1799 stack, class_2371<class_1856> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return class_1799.field_8037;
        }
        class_1856 refIngredient = (class_1856)ingredients.get(0);
        class_1799[] refMatchingStacks = refIngredient.method_8105();
        if (refMatchingStacks.length == 0) {
            return class_1799.field_8037;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            class_1856 ingredient = (class_1856)ingredients.get(i);
            @NotNull class_1799 match = class_1799.field_8037;
            for (class_1799 ingItemMatch : refMatchingStacks) {
                if (!ingredient.method_8093(ingItemMatch)) continue;
                match = ingItemMatch;
                break;
            }
            if (!match.method_7960()) continue;
            return class_1799.field_8037;
        }
        class_1799 match = this.findMatchingModCandidate(stack, Arrays.asList(refMatchingStacks));
        if (match.method_7960()) {
            match = refMatchingStacks[0];
        }
        return match;
    }

    private int setupLookup(InventoryLookup inv, @NotNull class_1799 stack) {
        int n = inv.method_5439();
        for (int i = 0; i < n; ++i) {
            inv.method_5447(i, stack);
        }
        return inv.method_5439();
    }

    public static class Result {
        @NotNull
        private final class_1799 stack;
        private final int size;

        public Result(@NotNull class_1799 stack, int size) {
            this.stack = stack;
            this.size = size;
        }

        @NotNull
        public class_1799 getStack() {
            return this.stack;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class InventoryLookup
    extends class_1715 {
        private final class_1799[] stackList;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.stackList = new class_1799[width * height];
            Arrays.fill(this.stackList, class_1799.field_8037);
        }

        public int method_5439() {
            return this.stackList.length;
        }

        @NotNull
        public class_1799 method_5438(int slot) {
            return slot >= this.method_5439() ? class_1799.field_8037 : this.stackList[slot];
        }

        @NotNull
        public class_1799 method_5441(int slot) {
            return class_1799.field_8037;
        }

        @NotNull
        public class_1799 method_5434(int slot, int count) {
            return class_1799.field_8037;
        }

        public void method_5447(int slot, @NotNull class_1799 stack) {
            this.stackList[slot] = stack;
        }
    }
}

